/*
 * Decompiled with CFR 0.152.
 */
package com.dinzeer.srelic.specialattacks;

import com.dinzeer.srelic.entity.BlackHole;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.concentrationrank.ConcentrationRankCapabilityProvider;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class BlackHolePro {
    public static void doSlash(LivingEntity playerIn, float roll, int lifetime, Vec3 centerOffset, boolean critical, double damage, float minSpeed, float maxSpeed, int count, int cc) {
        BlackHolePro.doSlash(playerIn, roll, lifetime, centerOffset, critical, damage, KnockBacks.cancel, minSpeed, maxSpeed, count, cc);
    }

    public static void doSlash(LivingEntity playerIn, float roll, int lifetime, Vec3 centerOffset, boolean critical, double damage, KnockBacks knockback, float minSpeed, float maxSpeed, int count, int cc) {
        int colorCode = cc;
        BlackHolePro.doSlash(playerIn, roll, lifetime, colorCode, centerOffset, critical, damage, knockback, minSpeed, maxSpeed, count);
    }

    private static float getRadius(int spellLevel, LivingEntity entity) {
        return (float)(2 * spellLevel + 4) + 0.125f * BlackHolePro.getSpellPower(spellLevel, (Entity)entity);
    }

    public static float getSpellPower(int spellLevel, @Nullable Entity sourceEntity) {
        double entitySpellPowerModifier = 1.0;
        double entitySchoolPowerModifier = 1.0;
        if (sourceEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)sourceEntity;
            entitySpellPowerModifier = (float)livingEntity.m_21133_(Attributes.f_22281_);
        }
        return (float)((0.8 + 1.2 * (double)(spellLevel - 1)) * entitySpellPowerModifier * entitySchoolPowerModifier * 1.0);
    }

    public static HitResult checkEntityIntersecting(Entity entity, Vec3 start, Vec3 end, float bbInflation) {
        Vec3 hitPos = null;
        if (entity.isMultipartEntity()) {
            for (PartEntity p : entity.getParts()) {
                Vec3 hit = p.m_20191_().m_82400_((double)bbInflation).m_82371_(start, end).orElse(null);
                if (hit == null) continue;
                hitPos = hit;
                break;
            }
        } else {
            hitPos = entity.m_20191_().m_82400_((double)bbInflation).m_82371_(start, end).orElse(null);
        }
        if (hitPos != null) {
            return new EntityHitResult(entity, hitPos);
        }
        return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)end));
    }

    private static HitResult internalRaycastForEntity(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks, float bbInflation, Predicate<? super Entity> filter) {
        BlockHitResult blockHitResult = null;
        if (checkForBlocks) {
            blockHitResult = level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, originEntity));
            end = blockHitResult.m_82450_();
        }
        AABB range = originEntity.m_20191_().m_82369_(end.m_82546_(start));
        ArrayList<HitResult> hits = new ArrayList<HitResult>();
        List entities = level.m_6249_(originEntity, range, filter);
        for (Entity target : entities) {
            HitResult hit = BlackHolePro.checkEntityIntersecting(target, start, end, bbInflation);
            if (hit.m_6662_() == HitResult.Type.MISS) continue;
            hits.add(hit);
        }
        if (!hits.isEmpty()) {
            hits.sort(Comparator.comparingDouble(o -> o.m_82450_().m_82557_(start)));
            return (HitResult)hits.get(0);
        }
        if (checkForBlocks) {
            return blockHitResult;
        }
        return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)end));
    }

    public static boolean canHitWithRaycast(Entity entity) {
        return entity.m_6087_() && entity.m_6084_();
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, float distance, boolean checkForBlocks, float bbInflation) {
        Vec3 start = originEntity.m_146892_();
        Vec3 end = originEntity.m_20154_().m_82541_().m_82490_((double)distance).m_82549_(start);
        return BlackHolePro.internalRaycastForEntity(level, originEntity, start, end, checkForBlocks, bbInflation, BlackHolePro::canHitWithRaycast);
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks) {
        return BlackHolePro.internalRaycastForEntity(level, originEntity, start, end, checkForBlocks, 0.0f, BlackHolePro::canHitWithRaycast);
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, float distance, boolean checkForBlocks) {
        Vec3 start = originEntity.m_146892_();
        Vec3 end = originEntity.m_20154_().m_82541_().m_82490_((double)distance).m_82549_(start);
        return BlackHolePro.raycastForEntity(level, originEntity, start, end, checkForBlocks);
    }

    private static float getDamage(int spellLevel, LivingEntity entity) {
        return BlackHolePro.getSpellPower(spellLevel, (Entity)entity) * 2.0f;
    }

    public static void doSlash(LivingEntity playerIn, float roll, int lifetime, int colorCode, Vec3 centerOffset, boolean critical, double damage, KnockBacks knockback, float minSpeed, float maxSpeed, int count) {
        Level level = playerIn.m_9236_();
        float radius = BlackHolePro.getRadius((int)damage, playerIn);
        HitResult raycast = BlackHolePro.raycastForEntity(level, (Entity)playerIn, 16.0f, true);
        Vec3 center = raycast.m_82450_();
        if (raycast instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)raycast;
            if (blockHitResult.m_82434_().m_122434_().m_122479_()) {
                center = center.m_82492_(0.0, (double)radius, 0.0);
            } else if (blockHitResult.m_82434_() == Direction.DOWN) {
                center = center.m_82492_(0.0, (double)(radius * 2.0f), 0.0);
            }
        }
        BlackHole blackHole = new BlackHole(level, playerIn);
        blackHole.m_5602_((Entity)playerIn);
        blackHole.setRadius(5.0f);
        blackHole.setDamage((float)((double)((float)playerIn.m_21133_(Attributes.f_22281_)) * 1.5));
        center.m_82520_(0.0, playerIn.m_20186_() - center.f_82480_, 0.0);
        blackHole.m_20219_(center);
        level.m_7967_((Entity)blackHole);
        Vec3 pos = playerIn.m_20182_().m_82520_(0.0, (double)playerIn.m_20192_() * 0.75, 0.0).m_82549_(playerIn.m_20154_().m_82490_((double)0.3f));
        pos = pos.m_82549_(VectorHelper.getVectorForRotation((float)-90.0f, (float)playerIn.m_5675_(0.0f)).m_82490_(centerOffset.f_82480_)).m_82549_(VectorHelper.getVectorForRotation((float)0.0f, (float)(playerIn.m_5675_(0.0f) + 90.0f)).m_82490_(centerOffset.f_82481_)).m_82549_(playerIn.m_20154_().m_82490_(centerOffset.f_82481_));
        EntityDrive drive = new EntityDrive(SlashBlade.RegistryEvents.Drive, level);
        level.m_7967_((Entity)drive);
        float speed = Mth.m_216283_((RandomSource)drive.m_9236_().m_213780_(), (float)minSpeed, (float)maxSpeed);
        drive.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        drive.setDamage(damage);
        drive.setSpeed(speed);
        drive.m_6686_(playerIn.m_20154_().f_82479_, playerIn.m_20154_().f_82480_, playerIn.m_20154_().f_82481_, drive.getSpeed(), 0.0f);
        drive.m_5602_((Entity)playerIn);
        drive.setRotationRoll(roll);
        drive.setColor(colorCode);
        drive.setIsCritical(critical);
        drive.setKnockBack(knockback);
        drive.setLifetime((float)lifetime);
        if (playerIn != null) {
            playerIn.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).ifPresent(rank -> drive.setRank(rank.getRankLevel(level.m_46467_())));
        }
    }
}

